/*
 * Decompiled with CFR 0.152.
 */
package com.filemaker.jdbc1;

import com.filemaker.jdbc.BaseConnection;
import com.filemaker.jdbc.BaseResultSet;
import com.filemaker.jdbc.BaseStatement;
import com.filemaker.jdbc.Driver;
import com.filemaker.jdbc.Encoding;
import com.filemaker.jdbc.FMAutoCommitRequest;
import com.filemaker.jdbc.FMConnectionResponse;
import com.filemaker.jdbc.FMDisconnectRequest;
import com.filemaker.jdbc.FMErrorResponse;
import com.filemaker.jdbc.FMEstablishSSLRequest;
import com.filemaker.jdbc.FMLoginRequest;
import com.filemaker.jdbc.FMLoginResponse;
import com.filemaker.jdbc.FMSQLException;
import com.filemaker.jdbc.FMStream;
import com.filemaker.jdbc.FMSuccessResponse;
import com.filemaker.jdbc.FMTransactionRequest;
import com.filemaker.jdbc.FM_API;
import com.filemaker.jdbc.MessageBlock;
import com.filemaker.jdbc.MessageBlockBytes;
import com.filemaker.jdbc.ProtocolMessage;
import java.io.IOException;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;

public abstract class CommonJ1Connection
implements BaseConnection {
    private FMStream fmStream;
    protected String server;
    protected int portNumber;
    protected String userID;
    protected String fmDatabase;
    protected boolean fmStatus;
    protected String compatible;
    protected boolean useSSL;
    protected boolean localSSL = false;
    protected int connectionTimeout = 0;
    protected int socketTimeout = 0;
    protected int verificationLevel = 3;
    protected int verificationFailureType = 1;
    protected short protocolVersion = 0;
    private Encoding encoding = Encoding.defaultEncoding();
    private String dbVersionNumber;
    private boolean isCloud = false;
    public boolean CONNECTION_OK = true;
    public boolean CONNECTION_BAD = false;
    public boolean autoCommit = true;
    public boolean readOnly = false;
    public Driver this_driver;
    private String this_url;
    private String cursor = null;
    public SQLWarning firstWarning = null;
    private int isolationLevel = 2;
    int lastMessage = 0;
    protected DatabaseMetaData metadata;

    @Override
    public FMStream getFMStream() {
        return this.fmStream;
    }

    @Override
    public abstract Statement createStatement() throws SQLException;

    @Override
    public abstract DatabaseMetaData getMetaData() throws SQLException;

    public void openConnection(String string, int n, Properties properties, String string2, String string3, Driver driver) throws SQLException {
        Object object;
        this.firstWarning = null;
        this.this_driver = driver;
        this.this_url = string3;
        this.userID = "";
        String string4 = "";
        this.server = string;
        this.portNumber = n;
        this.fmDatabase = string2;
        Object object2 = properties.propertyNames();
        while (object2.hasMoreElements()) {
            String string5 = object2.nextElement().toString();
            if (string5.compareToIgnoreCase("User") == 0) {
                this.userID = properties.getProperty(string5);
                continue;
            }
            if (string5.compareToIgnoreCase("Password") == 0) {
                string4 = properties.getProperty(string5);
                continue;
            }
            if (string5.compareToIgnoreCase("ConnectTimeout") == 0) {
                this.connectionTimeout = Integer.parseInt(properties.getProperty(string5));
                continue;
            }
            if (string5.compareToIgnoreCase("SocketTimeout") == 0) {
                this.socketTimeout = Integer.parseInt(properties.getProperty(string5));
                continue;
            }
            if (string5.compareToIgnoreCase("ServerName") == 0) {
                this.server = properties.getProperty(string5);
                continue;
            }
            if (string5.compareToIgnoreCase("ServerDataSource") == 0) {
                this.fmDatabase = properties.getProperty(string5);
                continue;
            }
            if (string5.compareToIgnoreCase("LocalSSL") == 0) {
                object = properties.getProperty(string5);
                if (((String)object).compareToIgnoreCase("Yes") != 0) continue;
                this.localSSL = true;
                continue;
            }
            if (string5.compareToIgnoreCase("CertificateVerificationLevel") == 0) {
                object = properties.getProperty(string5);
                if (((String)object).compareToIgnoreCase("None") == 0) {
                    this.verificationLevel = 0;
                }
                if (((String)object).compareToIgnoreCase("Certificate") == 0) {
                    this.verificationLevel = 1;
                }
                if (((String)object).compareToIgnoreCase("Name") == 0) {
                    this.verificationLevel = 2;
                }
                if (((String)object).compareToIgnoreCase("Full") != 0) continue;
                this.verificationLevel = 3;
                continue;
            }
            if (string5.compareToIgnoreCase("CertificateFailureType") != 0) continue;
            object = properties.getProperty(string5);
            if (((String)object).compareToIgnoreCase("None") == 0) {
                this.verificationFailureType = 0;
            }
            if (((String)object).compareToIgnoreCase("Warning") == 0) {
                this.verificationFailureType = 1;
            }
            if (((String)object).compareToIgnoreCase("Error") != 0) continue;
            this.verificationFailureType = 2;
        }
        if (this.userID.length() == 0) {
            throw new FMSQLException("User ID must be specified", "08004", 27070);
        }
        this.fmStatus = this.CONNECTION_BAD;
        this.useSSL = false;
        object2 = properties.getProperty("loglevel", "0");
        int n2 = 0;
        try {
            n2 = Integer.parseInt((String)object2);
            if (n2 > 2 || n2 < 1) {
                n2 = 0;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n2 > 0) {
            Driver.setLogLevel(n2);
            this.enableDriverManagerLogging();
        }
        if (Driver.logInfo) {
            Driver.info("dbc.openConnection(\"" + this.server + "\"," + n + ",info,\"" + this.fmDatabase + "\",\"" + string3 + "\",driver);");
        }
        if (Driver.logInfo) {
            Driver.info("//" + Driver.getVersion());
        }
        try {
            this.fmStream = new FMStream(this.server, n, this.connectionTimeout, this.socketTimeout);
        }
        catch (ConnectException connectException) {
            throw new FMSQLException("Connection refused. Check that the host address and port are correct and that xDBC sharing is enabled on the host.", "08004", 27071);
        }
        catch (UnknownHostException unknownHostException) {
            throw new FMSQLException("Unknown host: " + unknownHostException.getMessage(), "08001", 27072);
        }
        catch (IOException iOException) {
            throw new FMSQLException("Connection refused: " + iOException.getMessage(), "08001", 27072);
        }
        catch (Exception exception) {
            throw new FMSQLException("Connection failed: " + exception.getMessage(), "08001", 27073);
        }
        try {
            int n3;
            Object object3;
            ProtocolMessage protocolMessage;
            object = MessageBlock.getBlock(this.fmStream);
            byte[] byArray = ((MessageBlockBytes)object).blockBytes;
            short s = ((MessageBlockBytes)object).commandType;
            if (s == 67) {
                protocolMessage = new FMConnectionResponse(byArray);
                this.protocolVersion = ((FMConnectionResponse)protocolMessage).getProtocolVersion();
                object3 = ((FMConnectionResponse)protocolMessage).getServerVersion();
                n3 = ((FMConnectionResponse)protocolMessage).getCapabilities();
                if (this.protocolVersion != 9 && this.protocolVersion != 11 && this.protocolVersion < 12) {
                    throw new FMSQLException("Driver requires a more recent version of xDBC listener", "08004", 27074);
                }
            } else {
                if (s == 69) {
                    FMErrorResponse fMErrorResponse = new FMErrorResponse(byArray);
                    int n4 = fMErrorResponse.getErrorCode();
                    String string6 = fMErrorResponse.getErrorMessage();
                    throw new FMSQLException(string6, "08004", 27075);
                }
                throw new FMSQLException("Problem connecting to host", "08004", 27076);
            }
            if (this.protocolVersion >= 12 && (!this.fmStream.getIsLocalListener() || this.localSSL)) {
                protocolMessage = new FMEstablishSSLRequest(this.protocolVersion);
                protocolMessage.send(this.fmStream);
                try {
                    Thread.sleep(100L);
                    this.fmStream.establishSSL(this.localSSL, this.verificationLevel, this.verificationFailureType);
                }
                catch (SQLWarning sQLWarning) {
                    this.addWarning(sQLWarning.getMessage());
                }
                catch (FMSQLException fMSQLException) {
                    throw fMSQLException;
                }
                catch (Exception exception) {
                    object = MessageBlock.getBlock(this.fmStream);
                    if (object != null) {
                        byArray = ((MessageBlockBytes)object).blockBytes;
                        s = ((MessageBlockBytes)object).commandType;
                        if (s == 69) {
                            FMErrorResponse fMErrorResponse = new FMErrorResponse(byArray);
                            int n5 = fMErrorResponse.getErrorCode();
                            String string7 = fMErrorResponse.getErrorMessage();
                            throw new FMSQLException(string7, "08004", 27077);
                        }
                        throw new FMSQLException(exception.getMessage(), "08007", 27079);
                    }
                    throw new FMSQLException(exception.getMessage(), "08007", 27079);
                }
            }
            protocolMessage = new FMLoginRequest(this.protocolVersion, 0, 65534, "JDBC", this.fmDatabase, this.userID, string4, 1);
            protocolMessage.send(this.fmStream);
            object = MessageBlock.getBlock(this.fmStream);
            byArray = ((MessageBlockBytes)object).blockBytes;
            s = ((MessageBlockBytes)object).commandType;
            if (s != 71) {
                if (s == 69) {
                    object3 = new FMErrorResponse(byArray);
                    n3 = ((FMErrorResponse)object3).getErrorCode();
                    String string8 = ((FMErrorResponse)object3).getErrorMessage();
                    throw new FMSQLException(string8, "08004", 27077);
                }
                throw new FMSQLException("Unexpected listener response type " + s, "08S01", 27078);
            }
            object3 = new FMLoginResponse(byArray);
            String string9 = ((FMLoginResponse)object3).getFileMakerVersion();
            this.dbVersionNumber = this.extractVersionNumber(string9);
        }
        catch (Exception exception) {
            if (this.fmStream != null) {
                try {
                    this.fmStream.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            throw new FMSQLException(exception.getMessage(), "08007", 27079);
        }
        this.fmStatus = this.CONNECTION_OK;
    }

    public Driver getDriver() {
        if (Driver.logInfo) {
            Driver.info("driver = dbc.getDriver();");
        }
        return this.this_driver;
    }

    @Override
    public short getProtocolVersion() {
        return this.protocolVersion;
    }

    @Override
    public void addWarning(String string) {
        if (Driver.logInfo) {
            Driver.info("dbc.addWarning(\"" + string + "\");");
        }
        if (this.firstWarning != null) {
            this.firstWarning.setNextWarning(new SQLWarning(string));
        } else {
            this.firstWarning = new SQLWarning(string);
        }
    }

    @Override
    public BaseResultSet execSQL(String string) throws SQLException {
        if (Driver.logInfo) {
            Driver.info("rs = dbc.execSQL(\"" + string + "\");");
        }
        Object[] objectArray = new Object[]{};
        String[] stringArray = new String[]{};
        BaseStatement baseStatement = (BaseStatement)((Object)this.createStatement());
        return FM_API.execDirect(new String[]{string}, objectArray, stringArray, baseStatement);
    }

    @Override
    public void setCursorName(String string) throws SQLException {
        if (Driver.logInfo) {
            Driver.info("dbc.setCursorName(\"" + string + "\");");
        }
        this.cursor = string;
    }

    @Override
    public String getCursorName() throws SQLException {
        if (Driver.logInfo) {
            Driver.info("String cursorName = dbc.getCursorName();");
        }
        return this.cursor;
    }

    public String getURL() throws SQLException {
        if (Driver.logInfo) {
            Driver.info("String url = dbc.getURL();");
        }
        return this.this_url;
    }

    public String getUserName() throws SQLException {
        if (Driver.logInfo) {
            Driver.info("String userName = dbc.getUserName();");
        }
        return this.userID;
    }

    @Override
    public Encoding getEncoding() throws SQLException {
        if (Driver.logInfo) {
            Driver.info("Encoding encoding = dbc.getEncoding();");
        }
        return this.encoding;
    }

    public void close() throws SQLException {
        if (Driver.logInfo) {
            Driver.info("dbc.close();");
        }
        if (this.fmStream != null) {
            try {
                FMDisconnectRequest fMDisconnectRequest = new FMDisconnectRequest();
                fMDisconnectRequest.send(this.fmStream);
                this.fmStream.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.fmStream = null;
            }
        }
    }

    public String nativeSQL(String string) throws SQLException {
        if (Driver.logInfo) {
            Driver.info("String nativeSql = dbc.nativeSQL(\"" + string + "\");");
        }
        return string;
    }

    public SQLWarning getWarnings() throws SQLException {
        if (Driver.logInfo) {
            Driver.info("SQLWarning warnings = dbc.getWarnings();");
        }
        return this.firstWarning;
    }

    public void clearWarnings() throws SQLException {
        if (Driver.logInfo) {
            Driver.info("dbc.clearWarnings();");
        }
        this.firstWarning = null;
    }

    public void setReadOnly(boolean bl) throws SQLException {
        if (Driver.logInfo) {
            Driver.info("dbc.setReadOnly(" + bl + ");");
        }
        this.readOnly = bl;
    }

    public boolean isReadOnly() throws SQLException {
        if (Driver.logInfo) {
            Driver.info("boolean readOnly = dbc.isReadOnly();");
        }
        return this.readOnly;
    }

    @Override
    public void setAutoCommit(boolean bl) throws SQLException {
        MessageBlockBytes messageBlockBytes;
        if (Driver.logInfo) {
            Driver.info("dbc.setAutoCommit(" + bl + ");");
        }
        if (this.autoCommit == bl) {
            return;
        }
        FMAutoCommitRequest fMAutoCommitRequest = new FMAutoCommitRequest((short)(bl ? 1 : 0));
        fMAutoCommitRequest.send(this.fmStream);
        try {
            messageBlockBytes = MessageBlock.getBlock(this.fmStream);
        }
        catch (Exception exception) {
            throw new FMSQLException(exception.getMessage(), "HY000", 27080);
        }
        byte[] byArray = messageBlockBytes.blockBytes;
        short s = messageBlockBytes.commandType;
        if (s != 83) {
            if (s == 69) {
                FMErrorResponse fMErrorResponse = new FMErrorResponse(byArray);
                int n = fMErrorResponse.getErrorCode();
                String string = fMErrorResponse.getErrorMessage();
                throw new FMSQLException(string, "HY000", 27080);
            }
            throw new FMSQLException("Unexpected listener response type " + s, "08S01", 27081);
        }
        FMSuccessResponse fMSuccessResponse = new FMSuccessResponse(this.protocolVersion, byArray);
        this.autoCommit = bl;
    }

    @Override
    public boolean getAutoCommit() {
        if (Driver.logInfo) {
            Driver.info("boolean autoCommit = dbc.getAutoCommit();");
        }
        return this.autoCommit;
    }

    @Override
    public void commit() throws SQLException {
        MessageBlockBytes messageBlockBytes;
        if (Driver.logInfo) {
            Driver.info("dbc.commit();");
        }
        if (this.autoCommit) {
            return;
        }
        FMTransactionRequest fMTransactionRequest = new FMTransactionRequest(0);
        fMTransactionRequest.send(this.fmStream);
        try {
            messageBlockBytes = MessageBlock.getBlock(this.fmStream);
        }
        catch (Exception exception) {
            throw new FMSQLException(exception.getMessage(), "HY000", 27080);
        }
        byte[] byArray = messageBlockBytes.blockBytes;
        short s = messageBlockBytes.commandType;
        if (s != 83) {
            if (s == 69) {
                FMErrorResponse fMErrorResponse = new FMErrorResponse(byArray);
                int n = fMErrorResponse.getErrorCode();
                String string = fMErrorResponse.getErrorMessage();
                throw new FMSQLException(string, "HY000", 27082);
            }
            throw new FMSQLException("Unexpected listener response type " + s, "08S01", 27083);
        }
        FMSuccessResponse fMSuccessResponse = new FMSuccessResponse(this.protocolVersion, byArray);
    }

    public void rollback() throws SQLException {
        MessageBlockBytes messageBlockBytes;
        if (Driver.logInfo) {
            Driver.info("dbc.rollback();");
        }
        if (this.autoCommit) {
            return;
        }
        FMTransactionRequest fMTransactionRequest = new FMTransactionRequest(1);
        fMTransactionRequest.send(this.fmStream);
        try {
            messageBlockBytes = MessageBlock.getBlock(this.fmStream);
        }
        catch (Exception exception) {
            throw new FMSQLException(exception.getMessage(), "HY000", 27080);
        }
        byte[] byArray = messageBlockBytes.blockBytes;
        short s = messageBlockBytes.commandType;
        if (s != 83) {
            if (s == 69) {
                FMErrorResponse fMErrorResponse = new FMErrorResponse(byArray);
                int n = fMErrorResponse.getErrorCode();
                String string = fMErrorResponse.getErrorMessage();
                throw new FMSQLException(string, "HY000", 27084);
            }
            throw new FMSQLException("Unexpected listener response type " + s, "08S01", 27085);
        }
        FMSuccessResponse fMSuccessResponse = new FMSuccessResponse(this.protocolVersion, byArray);
    }

    public int getTransactionIsolation() throws SQLException {
        if (Driver.logInfo) {
            Driver.info("int level = dbc.getTransactionIsolation();");
        }
        return 2;
    }

    public void setTransactionIsolation(int n) throws SQLException {
        if (Driver.logInfo) {
            Driver.info("dbc.setTransactionIsolation(" + n + ");");
        }
        this.isolationLevel = n;
    }

    public void setCatalog(String string) throws SQLException {
        if (Driver.logInfo) {
            Driver.info("dbc.setCatalog(" + string + ");");
        }
    }

    public String getCatalog() throws SQLException {
        if (Driver.logInfo) {
            Driver.info("String catalog = dbc.getCatalog();");
        }
        return null;
    }

    public String getDBVersionNumber() {
        if (Driver.logInfo) {
            Driver.info("String versionNumber = dbc.getDBVersionNumber();");
        }
        return this.dbVersionNumber;
    }

    private String extractVersionNumber(String string) {
        this.isCloud = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String string2 = new String("");
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
        }
        String string3 = string.toUpperCase();
        if (string3.indexOf("CLOUD") != -1) {
            this.isCloud = true;
        }
        return string2;
    }

    private static int integerPart(String string) {
        int n;
        int n2;
        for (n2 = 0; n2 < string.length() && !Character.isDigit(string.charAt(n2)); ++n2) {
        }
        for (n = n2; n < string.length() && Character.isDigit(string.charAt(n)); ++n) {
        }
        if (n2 == n) {
            return 0;
        }
        return Integer.parseInt(string.substring(n2, n));
    }

    public int getServerMajorVersion() {
        if (Driver.logInfo) {
            Driver.info("int majorVersion = dbc.getServerMajorVersion();");
        }
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(this.dbVersionNumber, ".");
            int n = CommonJ1Connection.integerPart(stringTokenizer.nextToken());
            if (this.isCloud) {
                n = CommonJ1Connection.integerPart(stringTokenizer.nextToken());
            }
            return n;
        }
        catch (NoSuchElementException noSuchElementException) {
            return 0;
        }
    }

    public int getServerMinorVersion() {
        if (Driver.logInfo) {
            Driver.info("int minorVersion = dbc.getServerMinorVersion();");
        }
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(this.dbVersionNumber, ".");
            int n = CommonJ1Connection.integerPart(stringTokenizer.nextToken());
            if (n < 11) {
                n = CommonJ1Connection.integerPart(stringTokenizer.nextToken());
            }
            return CommonJ1Connection.integerPart(stringTokenizer.nextToken());
        }
        catch (NoSuchElementException noSuchElementException) {
            return 0;
        }
    }

    @Override
    public int getSQLType(int n) throws SQLException {
        int n2 = 12;
        n2 = n == 1 ? 12 : (n == 2 ? 8 : (n == 3 ? 91 : (n == 4 ? 92 : (n == 5 ? 93 : (n == 6 ? -4 : (n == 7 ? 8 : 12))))));
        return n2;
    }

    @Override
    public int getFMType(String string) {
        int n = -1;
        n = string.equalsIgnoreCase("varchar") ? 12 : (string.equalsIgnoreCase("numeric") ? 8 : (string.equalsIgnoreCase("date") ? 91 : (string.equalsIgnoreCase("time") ? 92 : (string.equalsIgnoreCase("timestamp") ? 93 : (string.equalsIgnoreCase("blob") ? -4 : 12)))));
        return n;
    }

    @Override
    public int getFMTypeFromName(String string) {
        int n = -1;
        n = string.equalsIgnoreCase("varchar") ? 1 : (string.equalsIgnoreCase("numeric") || string.equalsIgnoreCase("int") ? 2 : (string.equalsIgnoreCase("date") ? 3 : (string.equalsIgnoreCase("time") ? 4 : (string.equalsIgnoreCase("timestamp") ? 5 : (string.equalsIgnoreCase("blob") ? 6 : (string.equalsIgnoreCase("stream") ? 8 : 1))))));
        return n;
    }

    @Override
    public String getFMType(int n) {
        String string = "";
        string = n == 12 ? "varchar" : (n == 8 ? "numeric" : (n == 91 ? "date" : (n == 92 ? "time" : (n == 93 ? "timestamp" : (n == -4 ? "blob" : (n == 4 ? "int" : (n == 5 ? "smallint" : (n == -6 ? "tinyint" : "varchar"))))))));
        return string;
    }

    protected void enableDriverManagerLogging() {
        if (DriverManager.getLogStream() == null) {
            DriverManager.setLogStream(System.out);
        }
    }

    public boolean isClosed() throws SQLException {
        if (Driver.logInfo) {
            Driver.info("boolean isClosed = dbc.isClosed();");
        }
        return this.fmStream == null;
    }

    @Override
    public int getSQLType(String string) {
        return this.getFMType(string);
    }

    @Override
    public void cancelQuery() throws SQLException {
        if (Driver.logInfo) {
            Driver.info("dbc.cancelQuery();");
        }
    }
}

